﻿<%@ Page Title="Referral Contact Logs" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="True" CodeBehind="ReferralContactLogs.aspx.cs" Inherits="VIRP_WEB.Custom.EFR.ReferralContactLogs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
    <link type = "text/css" href = "styles/StyleSheet.css" />
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">
    
    <script type = "text/javascript">

        $(function() {
            if ($('#<%= HiddenFieldClearFlag.ClientID %>').val() === '1')
                $('#<%= TextBoxSearchCriteria.ClientID%>').focus();

        });
    </script>
        
    <br />
    <div class = "excludeSaveWarnings">
    <asp:Label SkinID="DataLabel" ID="LabelforTextBoxSearchCriteria" runat="server" AssociatedControlID="TextBoxSearchCriteria">Filter by Last Name:</asp:Label>
                            
        <asp:TextBox ID="TextBoxSearchCriteria" runat="server" Width="200px"></asp:TextBox>
        &nbsp;
        <asp:Button ID="ButtonSearch" runat="server" Text=" &nbsp;&nbsp;Go&nbsp;&nbsp; " OnClick = "ButtonOK_Clear"
            />
        &nbsp;
        <asp:Button ID="ButtonClear" runat="server" Text=" Clear " OnClick = "ButtonClear_Click" 
            />
        <asp:HiddenField ID="HiddenFieldClearFlag" runat="server" />
     </div> 
    <br />   
     <asp:GridView ID = "GridViewEFRReferralContacts" runat = "server" DataSourceID = "ObjectDataSourceEFRContacts" AutoGenerateColumns = "false"
        AllowPaging="True" PageSize="20" DataKeyNames = "ReferralId" OnRowCommand = "Contacts_RowCommand" AllowSorting = "true"
        CssClass="gridRegistry" PagerStyle-CssClass="pager" EmptyDataRowStyle-CssClass="gridRegistryEmpty" >
       <EmptyDataTemplate>
            No contact logs exist for any referrals
       </EmptyDataTemplate> 
        
        <Columns>
        
            <asp:TemplateField HeaderText = "Referral Number" SortExpression = "ReferralId" ItemStyle-HorizontalAlign="Center">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID = "LabelRefID" runat = "server" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ReferralId"))) %>' ></asp:Label> 
                
                </ItemTemplate> 
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="Patient Name" SortExpression = "PatientName">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelPatientName" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("PatientFullName"))) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Site Number" SortExpression = "StationNumber">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelStationNumber" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("StationNumber"))) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Facility" SortExpression = "InstitutionName">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelPatientName" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("InstitutionName"))) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Referral Date" SortExpression = "ReferralDate">
                    
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelReferralDate" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ReferralDate", "{0:d}"))) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
                                             
            <asp:TemplateField HeaderText="Status" SortExpression = "ReferralStatus">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelReferralStatus" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ReferralStatus"))) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="Last Contact Date" SortExpression = "LastContactDate">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelLastContactDate" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("LastContactDate", "{0:d}"))) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="Number of Contacts" SortExpression = "NumberOfContacts">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelNumberOfContacts" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("NumberOfContacts"))) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details" AccessibleHeaderText = "Select"  />
            
        </Columns>
    </asp:GridView>    
    
    <asp:ObjectDataSource ID="ObjectDataSourceEFRContacts" runat="server" 
            SelectMethod="GetContactLogs" 
            SelectCountMethod="GetContactLogsCount" 
            StartRowIndexParameterName="START_ROW" 
            MaximumRowsParameterName="MAX_ROWS" 
            SortParameterName="SORT_COLUMN"
            EnablePaging="True" 
            TypeName="VIRP.EFR.BLL.CONTACT_LOGManager">
            <SelectParameters>
                <asp:Parameter Name="CURRENT_USER" Type="String" />
                <asp:Parameter Name="CURRENT_REGISTRY_ID" Type="Int32" />
                <asp:Parameter Name="PATIENT_LAST_NAME" Type="String" />
                <asp:Parameter Name="SORT_COLUMN" Type="String" />
                <asp:Parameter Name="START_ROW" Type="Int32" />
                <asp:Parameter Name="MAX_ROWS" Type="Int32" />         
            </SelectParameters>        
   </asp:ObjectDataSource>
</asp:Content> 